const fz = {...require('zigbee-herdsman-converters/converters/fromZigbee'), legacy: require('zigbee-herdsman-converters/lib/legacy').fromZigbee};
const tz = require('zigbee-herdsman-converters/converters/toZigbee');
const exposes = require('zigbee-herdsman-converters/lib/exposes');
const reporting = require('zigbee-herdsman-converters/lib/reporting');
const constants = require('zigbee-herdsman-converters/lib/constants');
const ota = require('zigbee-herdsman-converters/lib/ota');
const converters = require('zigbee-herdsman-converters/converters/fromZigbee');
const e = exposes.presets;
const ea = exposes.access;

const fzLocal = {
    metering_datek: {
        cluster: 'seMetering',
        type: ['attributeReport', 'readResponse'],
        convert: (model, msg, publish, options, meta) => {
            const result = converters.metering.convert(model, msg, publish, options, meta);
            // Filter incorrect 0 energy values reported by the device:
            // https://github.com/Koenkk/zigbee2mqtt/issues/7852
            if (result.energy === 0) {
                delete result.energy;
            }
            return result;
        },
    },
}

module.exports = [
    {
        zigbeeModel: ['Meter Reader'],
        model: 'HSE2905E',
        vendor: 'Datek',
        description: 'Datek Eva AMS HAN power-meter sensor Re-Worked',
        fromZigbee: [fzLocal.metering_datek, fz.electrical_measurement, fz.temperature],
        toZigbee: [],
        //ota: ota.zigbeeOTA,
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ['haElectricalMeasurement', 'seMetering', 'msTemperatureMeasurement']);
            //await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            try {
                await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            } catch (error) {
                /* fails for some: https://github.com/Koenkk/zigbee2mqtt/issues/11867 */
            }
            const payload = [{
                attribute: 'rmsVoltagePhB',
                minimumReportInterval: 60,
                maximumReportInterval: 3600,
                reportableChange: 0,
            },
            {
                attribute: 'rmsVoltagePhC',
                minimumReportInterval: 60,
                maximumReportInterval: 3600,
                reportableChange: 0,
            },
            {
                attribute: 'rmsCurrentPhB',
                minimumReportInterval: 60,
                maximumReportInterval: 3600,
                reportableChange: 0,
            },
            {
                attribute: 'rmsCurrentPhC',
                minimumReportInterval: 60,
                maximumReportInterval: 3600,
                reportableChange: 0,
            }];
            await endpoint.configureReporting('haElectricalMeasurement', payload);
            await reporting.rmsVoltage(endpoint, {min: 60, max: 3600, change: 0});
            await reporting.rmsCurrent(endpoint, {min: 60, max: 3600, change: 0});
            await reporting.instantaneousDemand(endpoint, {min: 60, max: 3600, change: 0});
            await reporting.currentSummDelivered(endpoint, {min: 60, max: 3600, change: [1, 1]});
            await reporting.currentSummReceived(endpoint);
            await reporting.temperature(endpoint, {min: 60, max: 3600, change: 0});
            device.powerSource = 'DC source';
            device.save();
            
        },
        exposes: [e.power(), e.energy(), e.current(), e.voltage(), e.current_phase_b(), e.voltage_phase_b(), e.current_phase_c(),
            e.voltage_phase_c(), e.temperature()],
    },
];

